# -*- coding: utf-8 -*-
"""

"""
from __future__ import absolute_import
import os
import webbrowser


from PyQt5 import uic, QtGui
from PyQt5.QtCore import QSettings, Qt
from PyQt5.QtGui import QIcon
from PyQt5.QtWidgets import QDialog, QTableWidgetItem, QFileDialog, QTableView, QAbstractItemView, QCompleter, QMessageBox, QTabWidget, QWidget, QLineEdit, QToolButton, QPushButton, QTableWidget, QSlider, QDoubleSpinBox, QHeaderView
from qgis.core import Qgis, QgsLayerTreeLayer, QgsRectangle, QgsCoordinateTransform, QgsProject, edit, QgsVectorLayer
from .CompGisCore.comp_file_parser import CompFileParser
from .CompGisCore.gpkg_manager import GPKGManager
from .CompGisCore.identifytool import IdentifyTool
from .CompGisCore.relprec_cp_file_parser import RelprecCpParser

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'compgis_plugin_window.ui'), resource_suffix='')


class MainPluginWindow(QDialog, FORM_CLASS):
    scale_base = 100.0
    scale_steps_for_10_factor = 5

    def __init__(self, plugin_controler, iface, parent):
        """Constructor."""
        super(MainPluginWindow, self).__init__(parent)
        self.setWindowIcon(QIcon(":/plugins/Compgis3/resources/CompGIS.png"))
        # super(MainPluginWindow, self).__init__(parent)
        # Set up the user interface from Designer.
        # After setupUI you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        self.parent = parent
        self.plugin_controler = plugin_controler
        self.iface = iface
        self.Identify_tool = IdentifyTool(self.iface)
        self.last_tool = None

        # Settings
        self.qsettings = QSettings('IGN', 'CompGIS3')
        self.active_comput = None
        self.filename_multi_epoch = None

        self.tableComputations.setSelectionBehavior(QTableView.SelectRows)
        self.tableComputations.setEditTriggers(QAbstractItemView.NoEditTriggers)

        # List pts name for autocomplete searchbar
        self.pts_name = []
        self.set_active_computation()
        
        #definition of the structure of the interface
        self.tab_widget = self.findChild(QTabWidget, "tab_widget")
        
        self.tabPage1 = self.tab_widget.findChild(QWidget, "tabPage1")
        self.tabPage2 = self.tab_widget.findChild(QWidget, "tabPage2")
        self.tabPage3 = self.tab_widget.findChild(QWidget, "tabPage3")
        
        ###les groupes correspondent à ceux du fichier .ui
# <!-- partie 2 : fenêtre avec des onglets  -->
# <!--  groupe 2 : onglet N°1, affichage -->
	# <!-- groupe 2.1 : Actions sur la carte ou le gpkg-->
        self.addToMapButton = self.tabPage1.findChild(QPushButton, "addToMapButton")
        self.removeToMapButton = self.tabPage1.findChild(QPushButton, "removeToMapButton")
        self.delButton = self.tabPage1.findChild(QPushButton, "delButton")
	# <!-- groupe 2.2 : mise à jour du calcul-->
        self.updateButton = self.tabPage1.findChild(QPushButton, "updateButton")
        self.reloadButton = self.tabPage1.findChild(QPushButton, "reloadButton")
	# <!-- groupe 2.3 : outil pour l'ouverture des formulaires des observations-->
        self.id_obs_button = self.tabPage1.findChild(QPushButton, "id_obs_button")
	# <!-- groupe 2.4 : zoomer et filtrer sur un point-->
        self.searchBar = self.tabPage1.findChild(QLineEdit, "searchBar")
        self.zoomButton = self.tabPage1.findChild(QPushButton, "zoomButton")
        self.filterButton = self.tabPage1.findChild(QPushButton, "filterButton")
        
# <!-- groupe 3 : onglet N°2, affichage avancé-->
	# <!-- groupe 3.1 : seuils des forts résidus-->
		# <!-- groupe 3.1.1 premier seuil -->
        self.valueFirstResSlider = self.tabPage2.findChild(QDoubleSpinBox, "valueFirstResSlider")
        self.firstResSlider = self.tabPage2.findChild(QSlider, "firstResSlider")
		# <!-- groupe 3.1.2 deuxième seuil -->
        self.valueSecondResSlider = self.tabPage2.findChild(QDoubleSpinBox, "valueSecondResSlider")
        self.secondResSlider = self.tabPage2.findChild(QSlider, "secondResSlider")
	# <!-- groupe 3.2 : taille des ellipses-->
        self.valueSlider = self.tabPage2.findChild(QDoubleSpinBox, "valueSlider")
        self.ellipsoidSlider = self.tabPage2.findChild(QSlider, "ellipsoidSlider")
        
# <!-- groupe 4 onglet N°3 : multiépoques -->
	# <!-- groupe 4.1 chargement/ajout d'un fichier de précisions relatives -->
        self.browseButton_multi_epoch = self.tabPage3.findChild(QToolButton, "browseButton_multi_epoch")
	# <!-- groupe 4.2 : précision relative-->
        self.valueSliderRelprec = self.tabPage3.findChild(QDoubleSpinBox, "valueSliderRelprec")
        self.relprecSlider = self.tabPage3.findChild(QSlider, "relprecSlider")

#catching signals and generating the changement of state of widgets
    def connecting_signals(self):
        self.disconnecting_signals()
        self.tab_widget.currentChanged.connect(self.check_multi_epoch)
	# <!-- groupe 1.1 chargement/ajout d'un calcul -->
        self.browseButton.clicked.connect(self.browse_file)

	# <!-- groupe 1.2 : table des calculs chargés -->
        self.tableComputations.itemSelectionChanged.connect(self.set_active_computation)
        self.tableComputations.itemDoubleClicked.connect(self.open_link)

	# <!-- groupe 2.1 : Actions sur la carte ou le gpkg-->
        self.addToMapButton.clicked.connect(self.add_computation_to_map)
        self.addToMapButton.setFocusPolicy(Qt.NoFocus)
        self.removeToMapButton.clicked.connect(self.remove_compute_from_map)
        self.removeToMapButton.setFocusPolicy(Qt.NoFocus)
        self.delButton.clicked.connect(self.delete_computation_from_gpkg)
        self.delButton.setFocusPolicy(Qt.NoFocus)

	# <!-- groupe 2.2 : mise à jour du calcul-->
        self.updateButton.clicked.connect(self.update_computation)
        self.updateButton.setFocusPolicy(Qt.NoFocus)
        self.reloadButton.clicked.connect(self.reload_gpkg)
        self.reloadButton.setFocusPolicy(Qt.NoFocus)

	# <!-- groupe 2.3 : outil pour l'ouverture des formulaires des observations-->
        self.id_obs_button.clicked.connect(self.id_tool_for_form)
        self.iface.currentLayerChanged.connect(self.update_obs_id)
        self.iface.mapCanvas().mapToolSet.connect(self.on_map_tool_changed)

	# <!-- groupe 2.4 : zoomer et filtrer sur un point-->
        self.searchBar.textChanged.connect(self.update_zoom_filter_button_state)
        self.zoomButton.clicked.connect(self.zoom_to_point)
        self.zoomButton.setFocusPolicy(Qt.NoFocus)
        self.filterButton.clicked.connect(self.filter_change)
        self.filterButton.setFocusPolicy(Qt.NoFocus)

	# <!-- groupe 3.1 : seuils des forts résidus-->
		# <!-- groupe 3.1.1 premier seuil -->
        self.firstResSlider.valueChanged.connect(self.first_res_slider_on_value_change)
        self.valueFirstResSlider.valueChanged.connect(self.value_first_res_slider)
		# <!-- groupe 3.1.2 deuxième seuil -->
        self.secondResSlider.valueChanged.connect(self.second_res_slider_on_value_change)
        self.valueSecondResSlider.valueChanged.connect(self.value_second_res_slider)

	# <!-- groupe 3.2 : taille des ellipses-->
        self.ellipsoidSlider.valueChanged.connect(self.slider_on_value_change)
        self.valueSlider.valueChanged.connect(self.valueSlider_on_value_change)


# <!-- groupe 4 onglet N°3 : multiépoques -->
	# <!-- groupe 4.1 chargement/ajout d'un fichier de précisions relatives -->
        self.browseButton_multi_epoch.clicked.connect(self.browse_file_multi_epoch)
	# <!-- groupe 4.2 : précision relative-->
        self.relprecSlider.valueChanged.connect(self.slider_relprec_on_value_change)
        self.valueSliderRelprec.valueChanged.connect(self.value_relprec_slider_on_value_change)

    def disconnecting_signals(self):
#group 1.1
        try:
            self.browseButton.clicked.disconnect()
        except Exception as e:
            pass

#group 1.2
        try:
            self.tableComputations.itemSelectionChanged.disconnect()
        except Exception as e:
            pass
        try:
            self.tableComputations.itemDoubleClicked.connect.disconnect()
        except Exception as e:
            pass

#group 2.1
        try:
            self.addToMapButton.clicked.disconnect()
        except Exception as e:
            pass
        try:
            self.removeToMapButton.clicked.disconnect()
        except Exception as e:
            pass
        try:
            self.delButton.clicked.disconnect()
        except Exception as e:
            pass
#group 2.2
        try:
            self.updateButton.clicked.disconnect()
        except Exception as e:
            pass
        try:
            self.reloadButton.clicked.disconnect()
        except Exception as e:
            pass
#group 2.3
        try:
            self.id_obs_button.clicked.disconnect()
        except Exception as e:
            pass
        try:
            self.iface.currentLayerChanged.disconnect()
        except Exception as e:
            pass
        try:
            self.iface.mapCanvas().mapToolSet.disconnect()
        except Exception as e:
            pass
#group 2.4
        try:
            self.searchBar.returnPressed.disconnect()
        except Exception as e:
            pass
        try:
            self.zoomButton.clicked.disconnect()
        except Exception as e:
            pass
        try:
            self.filterButton.clicked.disconnect()
        except Exception as e:
            pass

#group 3.1
        try:
            self.firstResSlider.valueChanged.disconnect()
        except Exception as e:
            pass
        try:
            self.valueFirstResSlider.valueChanged.disconnect()
        except Exception as e:
            pass
        try:
            self.secondResSlider.valueChanged.disconnect()
        except Exception as e:
            pass
        try:
            self.valueSecondResSlider.valueChanged.disconnect()
        except Exception as e:
            pass
#group 3.2
        try:
            self.ellipsoidSlider.valueChanged.disconnect()
        except Exception as e:
            pass
        try:
            self.valueSlider.valueChanged.disconnect()
        except Exception as e:
            pass

#group 4.1
        try:
            self.browseButton_multi_epoch.clicked.disconnect()
        except Exception as e:
            pass
# group 4.2 
        try:
            self.relprecSlider.valueChanged.disconnect()
        except Exception as e:
            pass
        try:
            self.valueSliderRelprec.valueChanged.disconnect()
        except Exception as e:
            pass

    def check_multi_epoch(self):
        """
            update the status of enability of the widget used for relative precisions
        """

        if self.active_comput is None:
            self.pathLineEdit_multi_epoch.setEnabled(False)
            self.browseButton_multi_epoch.setEnabled(False)        
        else:
            if self.tab_widget.currentIndex() == 2:
                self.pathLineEdit_multi_epoch.setEnabled(True)
                self.browseButton_multi_epoch.setEnabled(True)
            else:
                self.pathLineEdit_multi_epoch.setEnabled(False)
                self.browseButton_multi_epoch.setEnabled(False)

    def update_obs_id(self, lyr):
        """
        update the status of enability and the message shown by overview of the obs_id_button
        """
        if lyr and isinstance(lyr, QgsVectorLayer) and lyr.name().startswith("obs"):
            self.id_obs_button.setEnabled(True)
            self.id_obs_button.setToolTip("")
        else:
            self.id_obs_button.setEnabled(False)
            self.id_obs_button.setChecked(False)
            self.id_obs_button.setToolTip("sélectionner la couche obs pour avoir accès à l'outil")
            self.id_tool_for_form()
            
    def on_map_tool_changed(self, tool):
        """
            catch the changement of tools in Qgis window to handle the status of the identifyTool
        """
        if isinstance (self.last_tool, type(self.Identify_tool)) and not isinstance(tool, type(self.Identify_tool)):
            self.id_obs_button.setChecked(False)
        self.last_tool = tool
        self.id_tool_for_form()

    def update_buttons_overview(self):
        """
        shows explanation on buttons by overview depending on the situation
        """
        # tant que le bouton recharger est inactif une info bulle explique qu'il faut mettre à jour pour pouvoir utiliser ce bouton
        self.reloadButton.setToolTip("" if self.reloadButton.isEnabled() else " mettre à jour un calcul pour avoir accès à l'outil")
        #si aucun calcul n'est sélectionné
        if self.active_comput is None:
        # une infobulle sur les boutons "Ajout à la carte", "Retirer de la carte", "Supprimer", "mettre à jour" montre le message.
            message = "Sélectionnez un calcul pour avoir accès à l'outil"
            self.addToMapButton.setToolTip(message)
            self.removeToMapButton.setToolTip(message)
            self.delButton.setToolTip(message)
            self.updateButton.setToolTip(message)
            self.browseButton_multi_epoch.setToolTip(message)


        # sinon pas d'infobulle sur les boutons "Supprimer" et "mettre à jour" 
        # si le bouton "Ajout à la carte" est actif pas d'info bulle, s'il est inactif infobulle : "Le calcul est déjà chargé dans la carte"
        # si le bouton "Retire de la carte" est actif pas d'info bulle, s'il est inactif infobulle : "Le calcul n'est pas chargé dans la carte"
        else:
            self.addToMapButton.setToolTip("" if self.addToMapButton.isEnabled() else "Le calcul est déjà chargé dans la carte")
            self.removeToMapButton.setToolTip("" if self.removeToMapButton.isEnabled() else "Le calcul n'est pas chargé dans la carte")
            self.delButton.setToolTip("")
            self.updateButton.setToolTip("")
            self.browseButton_multi_epoch.setToolTip("")

    def update_zoom_filter_button_state(self):
        """
        allows the use of zoom and filter buttons only when there is a text in the searchbar and it's contained in the list of points of the active computation
        """
        pt_name = self.searchBar.text() 

        # si le texte écrit dans la barre de recherche (dans la partie zoom et/ou filtre sur un point) est un point du calcul sélectionné les boutons zoomer et filtrer sont acitvés
        if pt_name in self.pts_name:
            self.filterButton.setEnabled(True)  
            self.zoomButton.setEnabled(True)  
        else:
            self.filterButton.setEnabled(False)
            self.zoomButton.setEnabled(False)

    def test_map_in(self):
        """
        activates or disactivates zoom and filter buttons depending on the computation is loaded to map
        """
        # si un calcul est sélectionné
        if self.active_comput is not None:
            exists, group = self.plugin_controler.computation_group_exists(self.plugin_controler.treeRoot,
                                                                                    self.active_comput)


            # si le calcul est chargé dans la carte : bouton "Ajout à la carte" désactivé et bouton "Retirer de la carte" activé
            # sinon le contraire
            if exists:
                self.addToMapButton.setEnabled(False)
                self.removeToMapButton.setEnabled(True)
                self.searchBar.setEnabled(True)
            else:
                self.addToMapButton.setEnabled(True)
                self.removeToMapButton.setEnabled(False)
                self.searchBar.setEnabled(False)
 
    def toggle_slider(self):
        """
        handle the status of all the sliders and value widgets associated to them
        """
    
        if self.active_comput is not None:
            exists, group = self.plugin_controler.computation_group_exists(self.plugin_controler.treeRoot,
                                                                                    self.active_comput)
            info = self.gpkg_db.get_computation_info(self.active_comput)
            # Computation is loaded in QGIS
            if exists:
                self.firstResSlider.setEnabled(True)
                self.valueFirstResSlider.setEnabled(True)
                self.secondResSlider.setEnabled(True)
                self.valueSecondResSlider.setEnabled(True)

                # If ellipsoid
                if info['invert_matrix'] == 1:
                    ell_layer = self.gpkg_db.get_layer_from_id_and_type(self.active_comput, 'ell')
                    if ell_layer is not None:
                        self.ellipsoidSlider.setEnabled(True)
                        self.valueSlider.setEnabled(True)

                        features = ell_layer.getFeatures()
                        for feature in features:
                            current_factor = int(feature["factor"])
                            break
                        self.update_slider_bounds(current_factor)
                        self.ellipsoidSlider.sliderReleased.connect(self.slider_valuechange)
                else:
                    self.update_slider_bounds(0)
                    try:
                        self.ellipsoidSlider.sliderReleased.disconnect(self.slider_valuechange)
                    except Exception:
                        pass
                # Get value of biggest residual threshold and set value qlinedit

                obs_layer = self.gpkg_db.get_layer_from_id_and_type(self.active_comput, 'obs')
                if obs_layer is not None:
                    features = obs_layer.getFeatures()
                    for feature in features:
                        current_first_threshold = feature["first_threshold_biggest_res"]
                        current_second_threshold = feature["second_threshold_biggest_res"]
                        break
                    self.first_res_slider_on_value_change(current_first_threshold * 10)
                    self.second_res_slider_on_value_change(current_second_threshold * 10)


                relprec_layer = self.gpkg_db.get_layer_from_id_and_type(self.active_comput, 'relprec')
                if relprec_layer is not None:
                    self.relprecSlider.setEnabled(True)
                    self.valueSliderRelprec.setEnabled(True)
                    
                    features_rp = relprec_layer.getFeatures()
                    for feature_rp in features_rp:
                        current_multiplier = int(feature_rp["multiplier"])
                        break
                    self.update_relprec_slider_bounds(current_multiplier)
                    self.relprecSlider.sliderReleased.connect(self.slider_relprec_valuechange)
 

            else:
                self.firstResSlider.setEnabled(False)
                self.valueFirstResSlider.setEnabled(False)
                self.secondResSlider.setEnabled(False)
                self.valueSecondResSlider.setEnabled(False)
    
                self.ellipsoidSlider.setEnabled(False)
                self.valueSlider.setEnabled(False)
                
                self.relprecSlider.setEnabled(False)
                self.valueSliderRelprec.setEnabled(False)
    
        else:
            self.firstResSlider.setValue(0)
            self.secondResSlider.setValue(0)
            self.valueFirstResSlider.setValue(0.1)
            self.valueSecondResSlider.setValue(0.1)

            self.ellipsoidSlider.setValue(0)
            self.valueSlider.setValue(0)

            self.relprecSlider.setValue(0)
            self.valueSliderRelprec.setValue(0)
            
            self.firstResSlider.setEnabled(False)
            self.valueFirstResSlider.setEnabled(False)
            self.secondResSlider.setEnabled(False)
            self.valueSecondResSlider.setEnabled(False)

            self.ellipsoidSlider.setEnabled(False)
            self.valueSlider.setEnabled(False)

            self.relprecSlider.setEnabled(False)
            self.valueSliderRelprec.setEnabled(False)
            
            try:
                self.ellipsoidSlider.sliderReleased.disconnect(self.slider_valuechange)
            except Exception:
                pass


# <!-- partie 1/ groupe 1 : partie commune à tous les onglets-->

#groupe 1.1 :  chargement/ajout d'un calcul 
    def browse_file(self):
        """Browse a comp file """
        lastDir = self.qsettings.value('lastCompPath', '.')
        filedlg = QFileDialog()
        filedlg.setFileMode(QFileDialog.AnyFile)
        filter = "Comp (*.comp)"
        filename, opt = filedlg.getOpenFileName(self.browseButton, self.tr('Select a file'), lastDir, filter)
        if filename:
            self.browse_sequel(filename)

    def browse_sequel(self,filename):
        """
        this method is separated from the preceding one to allow it to be called without the interface of browse_file.
        if the computation is already loaded, a message box indicates that
        """
        self.pathLineEdit.setText(filename)
        self.qsettings.setValue('lastCompPath', filename)

        comp = CompFileParser(filename, self.iface)
        if comp.computation is not None:
            id = comp.computation.timestamp_id

            if self.gpkg_db.compute_already_exists(id):
                MB = QMessageBox()
                MB.setWindowTitle("   Attention")
                MB.setText("le calcul est déjà chargé    ")
                MB.setWindowIcon(QIcon(":/plugins/Compgis3/resources/CompGIS.png"))
                MB.exec()

            else:
                # add the computation to gpkg
                self.gpkg_db.save_comp_to_gpkg(comp.computation)
                # Update table_widget
                self.active_comput = str(comp.computation.timestamp_id)
                self.update_bd_table()
                # self.add_computation_to_map()
        comp = None


# groupe 1.2 : table des calculs chargés
    def update_bd_table(self):
        """
        update the table of loaded computation in the plugin interface
        """
        self.tableComputations.setRowCount(0)
        self.tableComputations.clear()
        self.tableComputations.setColumnCount(5)


        # set label
        header = self.tr('"id;Nom;Date;projection;html"')
        self.tableComputations.setHorizontalHeaderLabels(header.split(";"))
        self.tableComputations.setColumnHidden(0, True)
        self.tableComputations.setColumnHidden(4, True)

        gpkg_computations = self.gpkg_db.get_computations_table()
        if gpkg_computations.isValid():
            features = gpkg_computations.getFeatures()
            line = 0
            pr = gpkg_computations.dataProvider()
            nb = pr.featureCount()
            self.tableComputations.setRowCount(nb)
            
            for feature in features:
                id = str(feature.id())  # Je sais pas pourquoi il faut caster en str
                invert_matrix = 'False'
                if feature['invert_matrix'] == 1:
                    invert_matrix = 'True'
                self.tableComputations.setItem(line, 0, QTableWidgetItem(id))
                self.tableComputations.setItem(line, 1, QTableWidgetItem(feature['name']))
                self.tableComputations.setItem(line, 2, QTableWidgetItem(feature['computation_start']))
                self.tableComputations.item(line, 2).setTextAlignment(Qt.AlignCenter)
                self.tableComputations.setItem(line, 3, QTableWidgetItem(feature['input_proj_name']))
                self.tableComputations.setItem(line, 4, QTableWidgetItem(feature['html_path']))
                line += 1
            self.tableComputations.horizontalHeader().setSectionResizeMode(QHeaderView.Stretch)
            self.tableComputations.setStyleSheet("""
                QHeaderView::section {
                    border-right: 1px solid #black;  /* Séparateur vertical entre les colonnes */
                    border-left: 1px solid #black;   /* Séparateur gauche */
                    border-top: 1px solid #black;    /* Séparateur en haut */
                    border-bottom: 1px solid #black; /* Séparateur en bas */
                    padding: 1px;
                }
            """)
            self.tableComputations.horizontalHeader().setDefaultAlignment(Qt.AlignCenter)
            row_height = self.tableComputations.verticalHeader().defaultSectionSize()
            padding = 10
            if nb ==0 :
                nb=1
            new_height = min(500, nb * row_height + padding + 25)
            
            self.table_computation.setMinimumHeight(new_height + 25)
            self.table_computation.setMaximumHeight(new_height + 25)


        if self.active_comput is not None:
            indexes = self.tableComputations.selectionModel().selectedRows()
            nrows = self.tableComputations.rowCount()
            for row in range(0, nrows):
                item = self.tableComputations.item(row, 0)
                comp_id = item.text()
                if comp_id == self.active_comput:
                    self.tableComputations.selectRow(row)
                    break

    def open_link(self, i):
        """
 open the HTML report in a browser, if there is no report a window shows up and says ther is no.
        """
        html_file = self.tableComputations.item(i.row(), 4).text()
        if os.path.exists(html_file):
            webbrowser.open(self.tableComputations.item(i.row(), 4).text())
        else:
            MB = QMessageBox()
            MB.setWindowTitle("   Attention")
            MB.setText("il n'y a pas de rapport HTML    ")
            MB.setWindowIcon(QIcon(":/plugins/Compgis3/resources/CompGIS.png"))
            MB.exec()

    def set_active_computation(self):
        """
        set active computation and activate/desactivate some variables to allow/forbid other actions in the plugin
        """
        indexes = self.tableComputations.selectionModel().selectedRows()

        if len(indexes) == 1:
           
            for index in sorted(indexes):
                self.active_comput = self.tableComputations.item(index.row(), 0).text()
                self.toggle_slider()
                # auto complete options
                self.pts_name = []
                self.pts_name = self.gpkg_db.get_list_points(self.active_comput)
                completer = QCompleter(self.pts_name)
                # add auto complete to qlineEdit
                self.searchBar.setCompleter(completer)
                self.cheminhtml = self.tableComputations.item(index.row(), 4).text()
                self.chemin_calc = self.cheminhtml[:-5]
                self.chemin_calc_up = self.cheminhtml[:-5]

                self.test_map_in()
                self.delButton.setEnabled(True)
                self.updateButton.setEnabled(True)
                self.update_buttons_overview()
                self.check_multi_epoch()

  
        else:
            self.active_comput = None
            self.toggle_slider()
            self.chemin_calc_up = None
            self.searchBar.clear()
            self.searchBar.setEnabled(False)
            self.addToMapButton.setEnabled(False)
            self.delButton.setEnabled(False)
            self.updateButton.setEnabled(False)
            self.removeToMapButton.setEnabled(False)
            self.update_buttons_overview()
            self.check_multi_epoch()


# <!-- partie 2 : fenêtre avec des onglets  -->
# <!--  groupe 2 : onglet N°1, affichage -->

	# <!-- groupe 2.1 : Actions sur la carte ou le gpkg-->
    def add_computation_to_map(self):
        """
        add the selected computation to the map if it's not already done
        """
        filename = self.chemin_calc_up
        if filename:
            if self.active_comput is not None:
                temp_act_comput = self.active_comput

                # Check if computation is already loaded in QGIS
                exists, group = self.plugin_controler.computation_group_exists(self.plugin_controler.treeRoot,
                                                                               self.active_comput)

                if not exists:
                    feat = self.gpkg_db.get_computation_info(self.active_comput)
                    group = self.plugin_controler.add_group(feat['name'], self.active_comput)
                    self.gpkg_db.add_compute_to_map(self.active_comput, group,feat['invert_matrix'])

                    # Zoom to group TODO : Move to a controller method
                    extent = QgsRectangle()
                    extent.setMinimal()
                    for child in group.children():
                        if isinstance(child, QgsLayerTreeLayer):
                            xform = QgsCoordinateTransform(child.layer().crs(),
                                                           self.iface.mapCanvas().mapSettings().destinationCrs(),
                                                           QgsProject.instance())
                   
                            extent.combineExtentWith(xform.transform(child.layer().extent()))
                    self.iface.mapCanvas().setExtent(extent)
                    self.iface.mapCanvas().refresh()
                    self.set_active_computation()

                   
                else: #ne devrait plus servir car dans ce cas le bouton est désactivé
                    mess = self.tr("Computation already loaded")
                    self.iface.messageBar().pushMessage("Info", mess,
                                                        level=Qgis.Warning, duration=5)
        else: #ne devrait plus servir car dans ce cas le bouton est désactivé
            message = "sélectionner le calcul à ajouter à la carte"
            self.iface.messageBar().pushMessage("Info", message,
                                                level=Qgis.Warning, duration=5)

    def remove_compute_from_map(self):
        """
        remove the selected computation from the map
        """
        filename = self.chemin_calc_up
        if filename:

            if self.active_comput is not None:
                # Check if computation is already loaded in QGIS
                exists, group = self.plugin_controler.computation_group_exists(self.plugin_controler.treeRoot,
                                                                               self.active_comput)
                if exists:
                    self.plugin_controler.treeRoot.removeChildNode(group)
                    self.set_active_computation() # permet de  gérer l'activation/désactivation des boutons et les infobulles
        else: #ne devrait plus servir car dans ce cas le bouton est désactivé
            message = "sélectionner le calcul à retirer de la carte"
            self.iface.messageBar().pushMessage("Info", message,
                                                level=Qgis.Warning, duration=5)

    def delete_computation_from_gpkg(self):
        """
        If compute exists on map, first remove and then delete entry in gpkg.
        Update QTableWidget
        the computation must be selected before being deleted
        """
        filename = self.chemin_calc_up
        if filename:
            if self.active_comput is not None:
                self.remove_compute_from_map()
                self.gpkg_db.delete_computation(self.active_comput)
                self.pathLineEdit.setText("")
                self.pathLineEdit_multi_epoch.setText("")
                self.active_comput = None
                self.update_bd_table()
                return("sortie")
        else: #ne devrait plus servir car dans ce cas le bouton est désactivé
            message = "sélectionner le calcul à supprimer"
            self.iface.messageBar().pushMessage("Info", message,
                                                level=Qgis.Warning, duration=5)

	# <!-- groupe 2.2 : mise à jour du calcul-->
    def update_computation(self):
        """
        deletes selected computation from gpkg, activates reloadButton and desactivates the others button and the possibility of selection in the computations table until the selected computation is reloaded.
        """
        #chemin_calc_up est une variable de set_active_computation pour s'assurer que le calcul à mettre à jour est sélectionné.
        #si ce n'est pas le cas un message d'avertissement apparaît dans la fenêtre QGis.
        #cette méthode, en fait, supprime le calcul du gpkg comme le bouton supprimer, active le bouton "recharger" et désactive les autres boutons ainsi que la sélection des calculs tant que le calcul n'a pas été rechargé.
        filename = self.chemin_calc_up

        if filename:
            self.reloadButton.setEnabled(True)
            self.addToMapButton.setEnabled(False)
            self.removeToMapButton.setEnabled(False)
            self.delButton.setEnabled(False)
            self.updateButton.setEnabled(False)
            self.tableComputations.setEnabled(False)
            if self.active_comput is not None:
                self.remove_compute_from_map()
                self.gpkg_db.delete_computation(self.active_comput)
                self.active_comput = None
                self.update_bd_table()
                self.chemin_calc_up = None
                return("sortie")
        else: #ne devrait plus servir car dans ce cas le bouton est désactivé
            message = "sélectionner le calcul à mettre à jour"
            self.iface.messageBar().pushMessage("Info", message,
                                                level=Qgis.Warning, duration=5)

    def reload_gpkg(self):
        """
        reloads the last selected computation, adds this one to the map, reactivates what has been desactivated by update_computation.
        """
        #chemin_calc est une variable de set_active_computation qui permet de s'assurer qu'on met à jour le dernier calcul sélectionné.
        # une fois le calcul rechargé, les boutons et la sélection des calculs sont réactivés.
        # chemin_calc est réinitialisé à None.
        #le calcul rechargé est automatiquement ajouté sur la carte
        filename = self.chemin_calc

        if filename:
            self.browse_sequel(filename)
            self.add_computation_to_map()
            self.reloadButton.setEnabled(False)
            self.tableComputations.setEnabled(True)
            self.chemin_calc = None
            self.set_active_computation()
 
	# <!-- groupe 2.3 : outil pour l'ouverture des formulaires des observations-->
    def id_tool_for_form(self):
        """
        changes the status of the button and activates/deactivates the overloaded identify tool
        """
        
        if self.id_obs_button.isChecked():
            self.id_obs_button.setText("Désactiver")
            self.iface.mapCanvas().setMapTool(self.Identify_tool)  # Active l'outil
  
        else:
            self.id_obs_button.setText("activer")
            if self.iface.mapCanvas().mapTool() == self.Identify_tool:
                self.iface.actionSelect().trigger() 

	# <!-- groupe 2.4 : zoomer et filtrer sur un point-->
    def zoom_to_point(self):
        """
        zoom to point select in search bar
        """

        pt_name = self.searchBar.text()
            # Select layer
        lyr_pts = QgsProject.instance().mapLayersByName('points')[0]
            # Select feature
        lyr_pts.selectByExpression(f'"name"=\'{pt_name}\'', QgsVectorLayer.SetSelection)
        selection = lyr_pts.selectedFeatures()
        feat = selection[0]
        buffer = feat.geometry().buffer(50, 50).boundingBox()
        xform = QgsCoordinateTransform(lyr_pts.crs(),
                                       self.iface.mapCanvas().mapSettings().destinationCrs(),
                                       QgsProject.instance())
        buffer = xform.transform(buffer)
        self.iface.mapCanvas().setExtent(buffer)
        self.iface.mapCanvas().refresh()

    def filter_change(self):
        """
        filter the observations linked to the point, of the active computation, selected in the searchBar
        """
        pt_name = self.searchBar.text()
        if self.filterButton.isChecked():
            self.filterButton.setText("ne plus filtrer")
            self.plugin_controler.filter_active_group_on_point_name(self.active_comput, pt_name)
 
        else:
            self.filterButton.setText("filtrer")
            pt_name = ""
            self.plugin_controler.filter_active_group_on_point_name(self.active_comput, pt_name)


# <!-- groupe 3 : onglet N°2, affichage avancé-->

	# <!-- groupe 3.1 : seuils des forts résidus-->
		# <!-- groupe 3.1.1 premier seuil -->
    
    def value_first_res_slider(self):
        value_slider_1 = self.valueFirstResSlider.value()

        if value_slider_1 != '':
            if value_slider_1 > 0:
                self.firstResSlider.blockSignals(True)
                self.firstResSlider.setValue(int(value_slider_1 * 10))
                self.firstResSlider.blockSignals(False)
                if self.active_comput is not None:

                    obs_layer = self.gpkg_db.get_layer_from_id_and_type(self.active_comput, 'obs')
                    if obs_layer is not None:
                        features = obs_layer.getFeatures()
                        with edit(obs_layer):
                            for feature in features:
                                feature["first_threshold_biggest_res"] = value_slider_1
                                obs_layer.updateFeature(feature)

                        self.iface.mapCanvas().refreshAllLayers()

    def first_res_slider_on_value_change(self, val):
       self.valueFirstResSlider.setValue(val / 10)

		# <!-- groupe 3.1.2 deuxième seuil -->
    def value_second_res_slider(self):
        value_slider_2 = self.valueSecondResSlider.value()

        if value_slider_2 != '':
            if value_slider_2 > 0:
                self.secondResSlider.blockSignals(True)
                self.secondResSlider.setValue(int(value_slider_2 * 10))
                self.secondResSlider.blockSignals(False)
                if self.active_comput is not None:

                    obs_layer = self.gpkg_db.get_layer_from_id_and_type(self.active_comput, 'obs')
                    if obs_layer is not None:
                        features = obs_layer.getFeatures()
                        with edit(obs_layer):
                            for feature in features:
                                feature["second_threshold_biggest_res"] = value_slider_2
                                obs_layer.updateFeature(feature)

                        self.iface.mapCanvas().refreshAllLayers()

    def second_res_slider_on_value_change(self, val):
       self.valueSecondResSlider.setValue(val / 10)

	# <!-- groupe 3.2 : taille des ellipses-->
    def slider_on_value_change(self, val):
        self.valueSlider.setValue(val)

    def update_slider_bounds(self, value):
        if value == 0:
            self.ellipsoidSlider.setMinimum(0)
            self.ellipsoidSlider.setMaximum(1)
            self.ellipsoidSlider.setValue(1)
        if value < 2500:
            self.ellipsoidSlider.setMinimum(1)
            self.ellipsoidSlider.setMaximum(value + 2500)
            self.ellipsoidSlider.setValue(value)
        else:
            self.ellipsoidSlider.setMinimum(value - 2500)
            self.ellipsoidSlider.setMaximum(value + 2500)
            self.ellipsoidSlider.setValue(value)

    def valueSlider_on_value_change(self):
        new_value_entered = int(self.valueSlider.value())
        self.ellipsoidSlider.setValue(new_value_entered)
        self.update_slider_bounds(new_value_entered)
        self.slider_valuechange()

    def slider_valuechange(self):
        value_slider = self.ellipsoidSlider.value()
        if self.active_comput is not None:
            ell_layer = self.gpkg_db.get_layer_from_id_and_type(self.active_comput, 'ell')
            if ell_layer is not None:
                features = ell_layer.getFeatures()
                with edit(ell_layer):
                    for feature in features:
                        feature["factor"] = value_slider
                        ell_layer.updateFeature(feature)
                self.iface.mapCanvas().refreshAllLayers()


# <!-- groupe 4 onglet N°3 : multiépoques -->
	# <!-- groupe 4.1 chargement/ajout d'un fichier de précisions relatives -->
    def browse_file_multi_epoch(self):
        """
        Browse a relprec file
        """

        lastDir = self.qsettings.value('lastCompPath', '.')
        filedlg = QFileDialog()
        filedlg.setFileMode(QFileDialog.AnyFile)
        filter = "relprec (*.csv)"

        filename_multi_epoch, opt = filedlg.getOpenFileName(self.browseButton_multi_epoch, self.tr('Select a file'), lastDir, filter)

        if filename_multi_epoch:
            self.browse_sequel_multi_epoch(filename_multi_epoch)
            
    def browse_sequel_multi_epoch(self, filename_multi_epoch):
        """
        this method is separated from the preceding one to allow it to be called without the interface of browse_file_multi_epoch.
        if the relprec file is already loaded, a message box indicates that
        """
        self.pathLineEdit_multi_epoch.setText(filename_multi_epoch)
        relprec_cp = RelprecCpParser(filename_multi_epoch, self.iface, self.pts_name, self.gpkg_db, self.active_comput)
        id = relprec_cp.active_compute

        if self.gpkg_db.relprec_already_exists(id):
            MB = QMessageBox()                
            MB.setWindowTitle("   Attention")           
            MB.setText("les précisions relatives sont déjà chargées")
            MB.setWindowIcon(QIcon(":/plugins/Compgis3/resources/CompGIS.png"))
            MB.exec()

        else:
            self.gpkg_db.save_lyr_relprec_to_gpkg(relprec_cp)
        
        exists, group = self.plugin_controler.computation_group_exists(self.plugin_controler.treeRoot,
                                                                                    self.active_comput)
        if exists:
            self.remove_compute_from_map()
            self.add_computation_to_map()
        
        relprec_cp = None

	# <!-- groupe 4.2 : précision relative-->
    def slider_relprec_on_value_change(self, val):
        self.valueSliderRelprec.setValue(val)

    def update_relprec_slider_bounds(self, value):
        if value == 0:
            self.relprecSlider.setMinimum(0)
            self.relprecSlider.setMaximum(0)
            self.relprecSlider.setValue(1)
        if value < 2500:
            self.relprecSlider.setMinimum(1)
            self.relprecSlider.setMaximum(value + 30)
            self.relprecSlider.setValue(value)
        else:
            self.relprecSlider.setMinimum(value - 2500)
            self.relprecSlider.setMaximum(value + 2500)
            self.relprecSlider.setValue(value)

    def value_relprec_slider_on_value_change(self):
        new_value_entered = int(self.valueSliderRelprec.value())
        self.relprecSlider.setValue(new_value_entered)
        self.update_relprec_slider_bounds(new_value_entered)
        self.slider_relprec_valuechange()
        
    def slider_relprec_valuechange(self):
        valueSliderRelprec = self.relprecSlider.value()
        if self.active_comput is not None:
            relprec_layer = self.gpkg_db.get_layer_from_id_and_type(self.active_comput, 'relprec')
            if relprec_layer is not None:
                features = relprec_layer.getFeatures()
                with edit(relprec_layer):
                    for feature in features:
                        feature["multiplier"] = valueSliderRelprec
                        relprec_layer.updateFeature(feature)

                self.iface.mapCanvas().refreshAllLayers()



    def debug_controler(self):
        # self.gpkg_db.display_gpkg_debug()
        pass

    def showEvent(self, a0: QtGui.QShowEvent) -> None:
        self.connecting_signals()
        self.gpkg_db = GPKGManager(self.plugin_controler)
        self.update_bd_table()

    def closeEvent(self, a0: QtGui.QCloseEvent) -> None:
        self.disconnecting_signals()
        print("CompGIS3 main window closed !!!")
