# -*- coding: utf-8 -*-

from __future__ import absolute_import

import os

from PyQt5.QtCore import QDir, QObject, QCoreApplication
from qgis._core import QgsProject, QgsLayerTreeGroup, QgsLayerTreeLayer, QgsCoordinateTransform, Qgis
import tempfile


class CompGisControler():
    def __init__(self, compgis_plugin):
        self.compgis_plugin = compgis_plugin
        self.qgs_project = QgsProject.instance()
        self.qgs_project_path = self.qgs_project.absolutePath()
        self.plugin_dir = os.path.dirname(__file__)
        self.treeRoot = self.qgs_project.layerTreeRoot()
        self.gpkg_dir = None
        self.gpkg_path = None

        # If QGS project not saved
        if self.qgs_project_path == '':

            mess = QCoreApplication.translate('CompGisControler', "Save QGIS project before !")
            self.compgis_plugin.iface.messageBar().pushMessage("Info", mess,
                                                               level=Qgis.Warning, duration=5)

        else:
            self.gpkg_dir = self.qgs_project_path
            self.gpkg_path = QDir(self.gpkg_dir).filePath('CompGIS.gpkg')

        self.connecting()


    def connecting(self):
        self.disconnecting()
        self.qgs_project.homePathChanged.connect(self.compgis_plugin_cleared)

    def disconnecting(self):
        try:
            self.qgs_project.homePathChanged.disconnect(self.compgis_plugin_cleared)
        except Exception as e:
            pass

    def compgis_plugin_cleared(self):
        self.disconnecting()
        self.compgis_plugin.dlg.close()
        self.compgis_plugin.first_start = True

    def project_saved(self):
        print(f"Project saved {self}")

    def project_wrote(self):
        print(f"Project wrote  {self}")

    def computation_group_exists(self, group, computation_id):

        for child in group.children():
            if isinstance(child, QgsLayerTreeGroup):
                if child.customProperty("Timestamp") == computation_id:
                    return True, child
                self.computation_group_exists(child, computation_id)
            elif isinstance(child, QgsLayerTreeLayer):
                pass
                # print('- layer: ' + child.name())
        return False, None

    def filter_active_group_on_point_name(self, computation_id, point_name):
        """

        :param id_computation:
        :return: list of layers
        """

        exists, group = self.computation_group_exists(self.treeRoot, computation_id)
        if exists:
            lyr_lst = self.get_group_layers(group)
            if point_name != '':
                for lyr in lyr_lst:

                    if lyr.name() == 'points':
                        lyr.setSubsetString(f'"name"=\'{point_name}\'')
                    elif lyr.name() == 'observations':
                        lyr.setSubsetString(f'"from_pt"=\'{point_name}\'  OR "to"=\'{point_name}\'')
                    elif lyr.name() == 'ellipses':
                        lyr.setSubsetString(f'"pt_name"=\'{point_name}\'')
                
            else:
                self.deactivate_filter(computation_id)

    def deactivate_filter(self, computation_id):
        """

        :param computation_id:
        :return:
        """
        exists, group = self.computation_group_exists(self.treeRoot, computation_id)
        if exists:
            lyr_lst = self.get_group_layers(group)
            for lyr in lyr_lst:
                lyr.setSubsetString('')

    def create_boundingbox_from_point(self, feat, lyr):
        pass

    def get_group_layers(self, group):
        """
        Get all layers in a group
        :param group:
        :return:
        """
        lyr_lst = []
        for child in group.children():
            if isinstance(child, QgsLayerTreeLayer):
                lyr_lst.append(child.layer())

        return lyr_lst

    def get_plugin_layers(self):
        for child in self.treeRoot.children():
            if isinstance(child, QgsLayerTreeGroup):
                self.get_group_layers(child)
            elif isinstance(child, QgsLayerTreeLayer):
                # print('- layer: ' + child.name())
                pass

    def add_group(self, name, compute_id):
        comp_group = self.treeRoot.insertGroup(0, name)
        comp_group.setCustomProperty("Timestamp", compute_id)
        return comp_group

    def __repr__(self):
        return f"Controler: qgs_project_path-> {self.qgs_project_path}; gpkg_path-> {self.gpkg_path}"

    def __del__(self):
        self.disconnecting()
        print("delete controler")
