from __future__ import absolute_import
import csv
import ast
from .comp3d_point import Comp3dPoint
from .relative_precision import RelativePrecision

class RelprecCpParser:

    def __init__(self, path, iface, lst_pt_name, gpkg, active_compute):
        self.path = path
        self.iface = iface
        self.csv_relprec_cp= []
        self.epochs = []
        self.list_points = lst_pt_name
        self.gpkg = gpkg
        self.active_compute = active_compute
        self.lst_pt_relprec = []
        self.crs = None
        self.parse_multi_epoch()

    def parse_multi_epoch(self):
    
        with open(self.path, mode='r', encoding='utf-8') as file:
            lines = file.readlines()    
        
        for i, line in enumerate(lines):
            line = line.strip()
            if line.startswith("* Époque"):
                self.epochs.append(line.split(":")[1].strip())
            elif line.startswith("name_pt"):
                header = line.split(";")
                data_start = i + 1
                break

       
        for line in lines[data_start:]:
            values = line.strip().split(";")
            row_dict = dict(zip(header, values))
            self.csv_relprec_cp.append(row_dict)  # Ajoute la ligne au résultat
        
        pts_lyr = self.gpkg.get_layer_from_id_and_type(self.active_compute, 'pt')
        self.crs = pts_lyr.crs()
        features = pts_lyr.getFeatures()

        dic_obj = [] 

        for pt in features:
            for obj in self.csv_relprec_cp:
                name = obj['name_pt']
                name_to_compare_1 = name + "_" + self.epochs[0]
                name_to_compare_2 = name + "_" + self.epochs[1]

                existing_entry = next((item for item in dic_obj if item["name"] == name), None)
                
                if existing_entry is None :
                    existing_entry = {'name': name, 'x_1': None, 'y_1': None, 'z_1': None,'x_2': None, 'y_2': None, 'z_2': None}
                    dic_obj.append(existing_entry)
                
                if pt['name'] == name_to_compare_1: 
                    coords_string = pt['coord_compensated_georef']
                    coords = ast.literal_eval(coords_string)
                    x_epoch_1 = coords[0]
                    y_epoch_1 = coords[1]
                    z_epoch_1 = coords[2]
                    existing_entry.update({'x_1': round(x_epoch_1, 3), 'y_1': round(y_epoch_1, 3), 'z_1': round(z_epoch_1, 3)})
                elif pt['name'] == name_to_compare_2:
                    coords_string = pt['coord_compensated_georef']
                    coords = ast.literal_eval(coords_string)
                    x_epoch_2 = coords[0]
                    y_epoch_2 = coords[1]
                    z_epoch_2 = coords[2]
                    existing_entry.update({'x_2': round(x_epoch_2, 3), 'y_2': round(y_epoch_2, 3), 'z_2': round(z_epoch_2, 3)})

        for data in dic_obj:
            data_name = data['name']
            if data['x_1'] is not None and data['x_2'] is not None:
                x = (data['x_1'] + data['x_2']) / 2
                y = (data['y_1'] + data['y_2']) / 2
                z = (data['z_1'] + data['z_2']) / 2

                for obj in self.csv_relprec_cp:
                    if obj['name_pt']== data['name']:
                        it = RelativePrecision(obj, data['name'], x, y, z, self.active_compute)
                        self.lst_pt_relprec.append(it)

        


                    
                    
            