from __future__ import absolute_import
from qgis._core import QgsField
from .functions import type_py2gpkg
from PyQt5.QtCore import QVariant

class RelativePrecision:
    """
        class  relative precision
    """

    def __init__(self, dico, data_name,x, y, z, active_compute):
        self.multiplier = 20
        self.set_parameters(dico, data_name,x, y, z, active_compute)
        self.__dict__.update(dico)


    def set_parameters(self, dico, data_name, x, y, z, active_compute):

        if dico['name_pt']== data_name:
            dico.update({'x': round(x, 3)})
            dico.update({'y': round(y, 3)})
            dico.update({'z': round(z, 3)})
            dico['sig_dz_68%'] = dico.pop('sig_dz') 
            dico.update({'sig_dz_95%': round(float(dico['sig_dz_68%'])*1.96, 2)})
            dico.update({'sig_dz_99%': round(float(dico['sig_dz_68%'])*2.57, 2)})
            dico.update({'idcomp': active_compute})

    def __str__(self):
        values = []
        for a in self.__dict__.values():
            values.append(a)
        return ', '.join(map(str, values))

    def get_attributes(self):
        return list(self.__dict__.keys())

    def get_qgis_fields(self):
        lst_qgis_fields = []
        for att in dir(self):
            if not att.startswith('__') and not callable(getattr(self, att)):
                pytype = type(getattr(self, att))
                lst_qgis_fields.append(QgsField(att, type_py2gpkg(pytype)))
        return lst_qgis_fields
                    
