# -*- coding: utf-8 -*-

"""
/***************************************************************************
 CompGisPlugin
                                 A QGIS plugin

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 Fonctions pour découper les polylignes en segments, récupérer les points
 que des segments intersectent et obtenir tous les couples entre une station
 et un point quelconque.
"""

from qgis.core import QgsFeature, QgsGeometry, QgsPoint

def to_segments(line):
    '''prend en entrée un ligne et retourne un vecteur contenant les segments
    qui composent cette ligne'''
    # get points
    # https://github.com/qgis/QGIS/blob/release-3_34/python/plugins/processing/algs/qgis/PointsFromLines.py
    points = []
    geom = line.geometry()
    if geom.isMultipart():
        lines = geom.asMultiPolyline()
        for line in lines:
            for i in range(len(line)):
                points.append(line[i]) #TODO pb à régler
    else:
        line = geom.asPolyline()
        for i in range(len(line)):
            points.append(line[i])

    # create segments
    # https://gis.stackexchange.com/questions/60307/creating-line-with-three-points-with-python-in-qgis
    segments = []
    for i in range(len(points)-1):
        seg = QgsFeature()
        seg.setGeometry((QgsGeometry.fromPolyline([QgsPoint(points[i]),QgsPoint(points[i+1])])))
        segments.append(seg)
    return(segments)

def points_crossing_segment(segment, pointLayer):
    """ return the names of the points from pointLayer that are in segment 
    segment : a qgis line which is a segment
    pointLayer : a qgis point layer """
    points = []
    for point in pointLayer.getFeatures():
        if point.geometry().intersects(segment.geometry()):
            points.append(point.attribute('name'))
    return(points)
    
def pairs(liste_dep, liste_arr):
    """ Ecrit toutes les paires de points avec un point de liste_dep au début """
    liste = []
    for d in liste_dep:
        for a in liste_dep + liste_arr:
            if a != d:
                liste.append((d,a))
    return(liste)
    
def cut_last_slash(string):
    i = len(string) - 1
    while i >= 0 and string[i] != '/' and string[i] != '\\' :
        i -= 1
    if i == -1:
        return("")
    return(string[:i+1])
    
    
            
        
