from qgis.gui import QgsMapToolIdentifyFeature
from qgis.PyQt.QtWidgets import QDialog, QVBoxLayout, QLabel, QGridLayout, QPushButton, QSizePolicy, QScrollArea, QWidget, QMessageBox

from qgis.PyQt.QtCore import Qt

from .identify_dialog import IdentifyDialog

class IdentifyTool(QgsMapToolIdentifyFeature):
    def __init__(self, iface):
        super().__init__(iface.mapCanvas())
        self.iface = iface

    def canvasReleaseEvent(self, event):
        layer = self.iface.activeLayer()
        results = self.identify(event.x(), event.y(), [layer])

        if not results:
            QMessageBox.information(None, "Identification", "Aucun objet trouvé.")
            return

        # Si un seul objet est trouvé, ouvrir directement le formulaire
        if len(results) == 1:
            feature_id = results[0].mFeature.id()
            layer.selectByIds([feature_id])
            self.iface.openFeatureForm(layer, layer.getFeature(feature_id))
            return

        # Afficher la boîte de dialogue avec plusieurs objets
        dialog = IdentifyDialog(results, layer, self.iface)
        dialog.exec_()

