from qgis.PyQt.QtWidgets import (
    QDialog, QVBoxLayout, QLabel, QGridLayout, QPushButton, 
    QSizePolicy, QScrollArea, QWidget
)
from qgis.PyQt.QtCore import Qt


class IdentifyDialog(QDialog):
    def __init__(self, results, layer, iface):
        super().__init__()

        self.layer = layer
        self.iface = iface
        self.setWindowTitle("Observations sélectionnées")
        self.setMinimumSize(600, 150)  # Taille minimale pour éviter une boîte trop petite
        
        main_layout = QVBoxLayout(self)


        label = QLabel("Quel formulaire ouvrir ?")
        label.setAlignment(Qt.AlignCenter | Qt.AlignTop)
        label.setStyleSheet("font-size: 16px; font-weight: bold; color: rgb(75,75,75);")
        main_layout.addWidget(label)

        scroll_area = QScrollArea()
        scroll_area.setWidgetResizable(False)
        scroll_widget = QWidget()
        grid_layout = QGridLayout(scroll_widget)
        grid_layout.setHorizontalSpacing(5)
        grid_layout.setVerticalSpacing(5)

        buttons = {}
        row, col = 0, 0
        max_button_width = 0

        for result in results:
            feat = result.mFeature
            feature_id = feat.id()
            
            # Extraction des champs
            field_from, field_to, field_read_obs = "from_pt", "to", "v_observation"
            try:
                champ1, champ2, champ3 = feat[field_from], feat[field_to], feat[field_read_obs]
            except IndexError:
                continue

            label_text = f"de : {champ1} vers : {champ2}\nobs mesurée : {champ3}"
            button = QPushButton(label_text)
            button.setMinimumWidth(100)
            button.setSizePolicy(QSizePolicy.Preferred, QSizePolicy.Fixed)

            grid_layout.addWidget(button, row, col)
            buttons[button] = feature_id
            
            button_width = button.sizeHint().width()
            max_button_width = max(max_button_width, button_width)


            col += 1
            if col == 3:  # Passer à la ligne suivante après 3 boutons
                col = 0
                row += 1

        self.setFixedWidth(max_button_width * 3 + 2*grid_layout.horizontalSpacing() * 2+50)
        scroll_area.setWidget(scroll_widget)
        main_layout.addWidget(scroll_area)

        self.adjustSize()

        # Bouton Annuler
        cancel_button = QPushButton("Annuler")
        cancel_button.clicked.connect(self.reject)
        main_layout.addWidget(cancel_button, alignment=Qt.AlignCenter)

        # Connexion des boutons
        for button, feature_id in buttons.items():
            button.clicked.connect(lambda _, fid=feature_id: self.open_feature(fid))

    def open_feature(self, feature_id):
        """Sélectionne l'objet et ouvre son formulaire."""
        self.layer.selectByIds([feature_id])
        self.iface.openFeatureForm(self.layer, self.layer.getFeature(feature_id))
        self.accept()

