from PyQt5.QtCore import QVariant, QDateTime
import numpy as np



_type_py2gpkg_dict = {
    int: QVariant.Int,
    str: QVariant.String,
    float: QVariant.Double,
    QDateTime: QVariant.String,
    bool: QVariant.Int,
    dict: QVariant.String,
    list: QVariant.String,
    type(None): QVariant.String,
    type(np.ndarray([])): QVariant.String,
    type(np.matrix): QVariant.String,
}



def type_py2gpkg(pytype):
    '''Return the closest gpkg type for a given python type'''
    if pytype in _type_py2gpkg_dict:
        return _type_py2gpkg_dict[pytype]
    else:
        raise NotImplementedError(
            "You may add custom `gpkgtype` to `" + str(pytype) + "` assignment in `_type_py2gpkg_dict`.")

