from __future__ import absolute_import
import json
import re
import ast

from PyQt5.QtCore import QLocale, QDateTime
from PyQt5.QtWidgets import QMessageBox
from PyQt5.QtGui import QIcon
from qgis._core import Qgis

from .comp3d_computation import Comp3dComputation
from .comp3d_ellipse import Comp3dEllipse
from .comp3d_observation import Comp3dObservation
from .comp3d_point import Comp3dPoint
from.comp3d_kernel import Comp3dKernel


class CompFileParser:
    def __init__(self, path, iface):
        self.path = path
        self.iface = iface
        self.json_comp = None
        self.computation = None
        self.parse()



    def parse(self):
        """
            parsing of the file ".comp" and building objects
            for future layers
        """


        with open(self.path) as file:
            index = file.read().find("{")
            file.seek(index, 0)
            self.json_comp = json.load(file)

        try:
            version_comp3d = re.findall("\d+\.\d+", self.json_comp['COMP3D_VERSION'])[0]
            version_comp3d = float(version_comp3d)
            if version_comp3d < 5.14:
                MB = QMessageBox()
                MB.setWindowTitle("   Attention")
                MB.setText("la version de Comp3D utilisée pour faire ce calcul est obsolète,\nveuillez le refaire avec une version plus récente")
                MB.setWindowIcon(QIcon(":/plugins/Compgis3/resources/CompGIS.png"))
                MB.exec()
        except Exception as e:
            print('CompFileParser: Oups problem :', version_comp3d, e)



# première partie pour le calcul lui-même
        html_path = self.path + '.html'
        all_data_files = self.json_comp['all_data_files']
        computation_start = self.json_comp['computation']['computation_start']
        loc_en = QLocale(QLocale.English)
        timestamp_id = loc_en.toDateTime(computation_start[0:-3], "yyyy-MMM-dd hh:mm:ss.zzz").toMSecsSinceEpoch()
        computation_start = str(QDateTime().fromMSecsSinceEpoch(timestamp_id).toString('yyyy-MM-dd hh:mm:ss'))
        earth_model_radius = self.json_comp['computation']['projection']['earth_model_radius']
        try:
            use_vertical_deviation = self.json_comp['computation']['use_vertical_deviation']
        except KeyError:
            try: 
                use_vertical_deviation = self.json_comp['computation']['use_vertical_deflection']
            except KeyError:
                use_vertical_deviation = False
        try:
            invert_matrix = self.json_comp['config']['invert_matrix']
        except KeyError:
            try:
                invert_matrix = self.json_comp['computation']["invertedMatrix"]
            except KeyError:
                invert_matrix = False

        name = self.json_comp['config']['name']
        description = self.json_comp['config']['description']
        compute_type = self.json_comp["config"]["compute_type"]
        local_center = self.json_comp['config']['local_center']
        try:
            use_ellips_height = self.json_comp['config']['use_ellips_height']
        except KeyError:
            use_ellips_height = False
            MB = QMessageBox()
            MB.setWindowTitle("   Attention")
            MB.setText("la version de Comp3D utilisée pour faire ce calcul est obsolète,\nveuillez le refaire avec une version plus récente")
            MB.setWindowIcon(QIcon(":/plugins/Compgis3/resources/CompGIS.png"))
            MB.exec()


        try:
            is_georef = self.json_comp['computation']['projection']['is_georef']
            input_proj_EPSG = self.json_comp['computation']['projection']['input_proj_EPSG']
            input_proj_def = self.json_comp['computation']['projection']['input_proj_def']
            input_proj_name = self.json_comp['computation']['projection']['input_proj_name']
        except KeyError as e:
            input_proj_EPSG = -1
            input_proj_name = "?"
            input_proj_def= -1
            is_georef = False
            print("old computation", e)

# creation de l'objet calcul
        self.computation = Comp3dComputation(timestamp_id, name, computation_start, description, compute_type,
                                             is_georef,
                                             input_proj_EPSG, input_proj_def, input_proj_name, local_center,
                                             earth_model_radius, use_vertical_deviation, invert_matrix,
                                             use_ellips_height, html_path)



# dans cet objet calcul début de la partie "points"
        for key, value in self.json_comp['points'].items():
            isStation = False
            centered = False
            scan_stat = False

            pt = {}

            for attr, val in self.json_comp['points'][key].items():
                if attr != u'stations':
                    pt[attr] = val
                elif attr == u'stations':
                    isStation = True

                    if val == []:
                        isStation = False
                    else:
# partie pour les observations
                        for ind, val in enumerate(self.json_comp['points'][key]['stations']):
                            obs_dic = val['observations']
                            lst_code = []
                            lst_file_id = []
                            for obs in obs_dic:
                                lst_code.append(obs['code'])
                                obs_file_id = str(obs['file_id'])
                                lst_file_id.append(obs_file_id)
                                chemin_file = self.path
                                str_to_delete = name+".comp"
                                chemin_obs_deb = chemin_file.replace(str_to_delete,"")
                                chemin_obs_fin = all_data_files.get(obs_file_id)
                                obs_file_name = chemin_obs_deb + chemin_obs_fin
                                obs["file_name"] = obs_file_name
                                file_temp = open(chemin_file, "r", encoding="utf-8", errors="replace")
                                try:
                                    for numero_ligne, ligne in enumerate(file_temp, start=1):
                                        if not ligne.startswith("*"):
                                            obs["num_line"] = numero_ligne
                                finally:
                                    file_temp.close()
                                
                                nb_digits = self.json_comp['config']['nb_digits']
                                for key_obs, val_obs in obs.items():
                                    if isinstance(val_obs, float):
                                        if key_obs in ("normalized_residual", "residual_std", "standardized_residual"):
                                            obs[key_obs] = f"{val_obs:.{nb_digits-3}f}"
                                        else:
                                            obs[key_obs] = f"{val_obs:.{nb_digits}f}"
                                # création d'un objet obs    
                                o = Comp3dObservation(obs,invert_matrix)
                                # tous les objets obs sont stockés dans une liste qui appartient à l'objet calcul
                                self.computation.lst_observations.append(o)

                        # make list of unique obs_code
                        lst_code = list(set(lst_code))
                        lst_file_id = list(set(lst_file_id))

                        # This is not a station :
                        if len(lst_code) == 1 and 4 in lst_code:  # Levelling = Not a station
                            isStation = False

                        if any(14 == code for code in lst_code) and any(15 == code for code in lst_code):
                            centered = True

                        if len(lst_code) == 3 and 4 in lst_code and 14 in lst_code and 15 in lst_code:
                            isStation = False
                        
                        if len(lst_file_id) == 1 and 101 in lst_code:
                            file_obs_name = all_data_files.get(obs_file_id)
                            file_name_end = file_obs_name[-3:]
                            if file_name_end.lower() == "xyz":
                                scan_stat = True

            # création d'un objet point
            p = Comp3dPoint(key, isStation, pt, centered, scan_stat)
            # tous les objets points sont stockés dans une liste qui appartient à l'objet calcul
            self.computation.lst_points.append(p)
            
# partie pour les ellipses
            
            if invert_matrix:
                diag_mat = pt['ellips']['matrix']
                # création d'un objet ellipse
                ell = Comp3dEllipse(key, diag_mat)
                # tous les objets ellipses sont stockés dans une liste qui appartient à l'objet calcul
                self.computation.lst_ellipses.append(ell)

        
# partie pour les noyaux de calculs si tel est le cas
        kernel = self.json_comp['computation']['kernel']
        if kernel:
            cores = {}
            for i, ind in enumerate(kernel):
                # création d'un objet kernel
                k = Comp3dKernel(i, ind, self.json_comp, self.computation, cores)
                # tous les objets kernel sont stockés dans une liste qui appartient à l'objet calcul
                self.computation.lst_indeterminations.append(k)
            
        return 1
