from __future__ import absolute_import
from qgis._core import QgsField
from .functions import type_py2gpkg

class Comp3dPoint:
    def __init__(self, name, isStation, dico, centered=False, scan_stat=False):
        """
            name(str) = name of the point
            dico(dictionnary) = contains all the attributes of Comp3dpoint parsed from the json
            isStation(Bool) = the point is a station if True
            centered(Bool) = the point is centered if True
            scan_stat(Bool) = the point is a laser station if True
        """
        self.name = name
        self.is_station = isStation
        self.centered = centered
        self.__dict__.update(dico)
        self.scan_stat = scan_stat

    def get_x(self):
        if hasattr(self, 'coord_compensated_georef'):
            return self.coord_compensated_georef[0]
        else:
            return self.coord_read[0]

    def get_y(self):
        if hasattr(self, 'coord_compensated_georef'):
            return self.coord_compensated_georef[1]
        else:
            return self.coord_read[1]

    def get_h(self):
        if hasattr(self, 'coord_compensated_georef'):
            return self.coord_compensated_georef[2]
        else:
            return self.coord_read[2]

    def __str__(self):
        values = []
        for a in self.__dict__.values():
            values.append(a)
        return ', '.join(map(str, values))

    def get_attributes(self):
        return list(self.__dict__.keys())

    def get_qgis_fields(self):
        lst_qgis_fields = []
        for att in dir(self):
            if not att.startswith('__') and not callable(getattr(self, att)):
                pytype = type(getattr(self, att))
                lst_qgis_fields.append(QgsField(att, type_py2gpkg(pytype)))
        return lst_qgis_fields