from __future__ import absolute_import
from qgis._core import QgsField
from .functions import type_py2gpkg

class Comp3dObservation:

    def __init__(self, dico,invert_matrix):
        self.__dict__.update(dico)
        if invert_matrix:#use standarized residual is more rigorous
            self.first_threshold_biggest_res = 2.5 # ajout d'un seuil résidu moyen (orange dans le html de comp)
            self.second_threshold_biggest_res = 4.1# ajout d'un seuil résidu moyen (orange dans le html de comp)
        else:
            self.first_threshold_biggest_res = 3.0# ajout d'un seuil résidu moyen (orange dans le html de comp)
            self.second_threshold_biggest_res = 6.0# ajout d'un seuil résidu moyen (orange dans le html de comp)
        self.rename_attribute('from', 'from_pt')

    def rename_attribute(self, old_name, new_name):
        self.__dict__[new_name] = self.__dict__.pop(old_name)

    def __str__(self):
        values = []
        for a in self.__dict__.values():
            values.append(a)
        return ', '.join(map(str, values))

    def get_type_value(self):
        values = []
        for a in self.__dict__.values():
            values.append(a)
        return ', '.join(map(str, map(type, values)))

    def get_attributes(self):
        return list(self.__dict__.keys())

    def get_qgis_fields(self):
        lst_qgis_fields = []
        for att in dir(self):
            if not att.startswith('__') and not callable(getattr(self, att)):
                pytype = type(getattr(self, att))
                lst_qgis_fields.append(QgsField(att, type_py2gpkg(pytype)))
        return lst_qgis_fields