from __future__ import absolute_import
from qgis._core import QgsField
from .functions import type_py2gpkg
from PyQt5.QtCore import QVariant

class Comp3dKernel:
    """
        class object kernel
    """

    def __init__(self, indetermination, indval, jsoncomp, computation, cores):
        """
            lst_coord(list) = list of tuple that are coords of all points contained in kernel.
            indetermination(int) = number of order of the kernel 
        """
        self.lst_coord = []
        self.indetermination = indetermination
                
        self.build_kernel( indval, jsoncomp, computation, cores)
        
    def build_kernel(self, indval, jsoncomp, computation, cores):

            if self.indetermination not in cores:        
                cores[self.indetermination] = {}

            for data in indval.values():
                indice_pt = data["num_pt"]
                name_pt = jsoncomp['all_point_names'][indice_pt]
                if name_pt not in cores[self.indetermination].values():
                    cores[self.indetermination]['name_pt'] = name_pt
                    for point in computation.lst_points:
                        if name_pt == point.name:
                            coords_str = point.coord_read
                            x = float(coords_str[0])
                            y = float(coords_str[1])
                            self.lst_coord.append([(x,y)])


 
    def __str__(self):
        values = []
        for a in self.__dict__.values():
            values.append(a)
        return ', '.join(map(str, values))

    def get_attributes(self):
        return list(self.__dict__.keys())

    def get_qgis_fields(self):
        lst_qgis_fields = []
        for att in dir(self):
            if not att.startswith('__') and not callable(getattr(self, att)):
                pytype = type(getattr(self, att))
                lst_qgis_fields.append(QgsField(att, type_py2gpkg(pytype)))
        return lst_qgis_fields
