from __future__ import absolute_import
import math

from qgis._core import QgsField
import numpy as np

from .functions import type_py2gpkg


class Comp3dEllipse:
    def __init__(self, pt_name, mat_diag):
        self.pt_name = pt_name
        self.diag_mat = mat_diag
        self.mat = None
        self.a, self.b = 0, 0
        self.theta = 0
        self.factor = 250
        self.sigma_x = 0
        self.sigma_y = 0
        self.sigma_z = 0
        self.dimension = None

        self.diag_to_matrix()

    def diag_to_matrix(self):
        """
        Recreate complete matrix from half matrix
        Not necessary but useful for debugging
        :return:
        """
        len_diag_mat = len(self.diag_mat)
        if len_diag_mat == 1:
            self.sigma_z = math.sqrt(self.diag_mat[0])
            self.dimension = 1

        if len_diag_mat == 3:
            self.dimension = 2
            self.mat = np.mat(np.eye(2))

            self.mat[0, 0] = self.diag_mat[0]
            self.mat[0, 1] = self.diag_mat[1]

            self.mat[1, 0] = self.diag_mat[1]
            self.mat[1, 1] = self.diag_mat[2]

            self.sigma_x = math.sqrt(self.mat[0, 0])
            self.sigma_y = math.sqrt(self.mat[1, 1])

            self.compute_axis_2D()
            self.mat = self.mat.tolist()

        if len_diag_mat == 6:
            self.dimension = 3

            self.mat = np.mat(np.eye(3))

            self.mat[0, 0] = self.diag_mat[0]
            self.mat[0, 1] = self.diag_mat[1]
            self.mat[0, 2] = self.diag_mat[2]

            self.mat[1, 0] = self.diag_mat[1]
            self.mat[1, 1] = self.diag_mat[3]
            self.mat[1, 2] = self.diag_mat[4]

            self.mat[2, 0] = self.diag_mat[2]
            self.mat[2, 1] = self.diag_mat[4]
            self.mat[2, 2] = self.diag_mat[5]

            self.sigma_x = math.sqrt(self.mat[0, 0])
            self.sigma_y = math.sqrt(self.mat[1, 1])
            self.sigma_z = math.sqrt(self.mat[2, 2])

            self.compute_axis_2D()
            self.mat = self.mat.tolist()

        ##################################################################
        # OLD version de comp3d, matrix is complete (now only half matrix is given)
        if len_diag_mat == 4:
            self.dimension = 2
            self.mat = np.mat(np.eye(2))

            self.mat[0, 0] = self.diag_mat[0]
            self.mat[0, 1] = self.diag_mat[1]
            self.mat[1, 0] = self.diag_mat[1]
            self.mat[1, 1] = self.diag_mat[2]

            self.sigma_x = math.sqrt(self.mat[0, 0])
            self.sigma_y = math.sqrt(self.mat[1, 1])
            self.compute_axis_2D()
            self.mat = self.mat.tolist()

        if len_diag_mat == 9:
            self.dimension = 3
            self.mat = np.mat(np.eye(3))

            self.mat[0, 0] = self.diag_mat[0]
            self.mat[0, 1] = self.diag_mat[1]
            self.mat[0, 2] = self.diag_mat[2]

            self.mat[1, 0] = self.diag_mat[3]
            self.mat[1, 1] = self.diag_mat[4]
            self.mat[1, 2] = self.diag_mat[5]

            self.mat[2, 0] = self.diag_mat[6]
            self.mat[2, 1] = self.diag_mat[7]
            self.mat[2, 2] = self.diag_mat[8]

            self.sigma_x = math.sqrt(self.mat[0, 0])
            self.sigma_y = math.sqrt(self.mat[1, 1])
            self.sigma_z = math.sqrt(self.mat[2, 2])

            self.compute_axis_2D()
            self.mat = self.mat.tolist()

    def compute_axis_2D(self):
        """
        Compute ellipse axis
        We extract the 2D matrix to compute directly axis in projection
        :return: None
        """
        mat = np.mat(np.eye(2))
        mat[0, 0] = self.mat[0, 0]
        mat[0, 1] = self.mat[0, 1]
        mat[1, 0] = self.mat[1, 0]
        mat[1, 1] = self.mat[1, 1]

        valp, vectp = np.linalg.eig(mat)

        semi_axis1 = math.sqrt(valp[0])
        semi_axis2 = math.sqrt(valp[1])

        # Detect semi major axis
        if semi_axis1 > semi_axis2:
            self.a = semi_axis1
            self.b = semi_axis2
            theta = math.atan2(vectp[0, 0], vectp[1, 0]) * 200 / math.pi
        else:
            self.a = semi_axis2
            self.b = semi_axis1
            theta = math.atan2(vectp[0, 1], vectp[1, 1]) * 200 / math.pi

        # Force theta [0, PI]
        while theta < 0:
            theta += 200
        while theta > 200:
            theta -= 200

        self.theta = theta

    def compute_axes(self):

        var_x = self.mat[0, 0]
        covar_xy = self.mat[0, 1]
        covar_yx = self.mat[1, 0]
        var_y = self.mat[1, 1]

        self.sigma_x = math.sqrt(var_x)
        self.sigma_y = math.sqrt(var_y)

        # #Methode Elise
        # #estimation_linéaire_mastèrePPMD_chap5_Ed2016.pdf page5
        # p1 = 0.5 * (var_x + var_y)
        # p2 = 0.5 * math.sqrt(
        #     (var_x - var_y)**2 + 4 * (covar_yx)**2)
        #
        # a2 = p1 + p2
        # b2 = p1 - p2
        # self.a, self.b = math.sqrt(a2), math.sqrt(b2)
        #
        # theta = 1/2 * math.atan(2 * covar_yx / (var_x - var_y))
        # self.theta = (theta * 180 / math.pi) + 90
        #
        # print(f"Methode1, {self.pt_name} {self.a, self.b} {self.theta * 200 / 180 } {2 * covar_yx/(var_x - var_y)}")
        # print(f"Variances,  {var_x, var_y} {covar_xy} {covar_yx} {(var_x - var_y)}")

        # Methode Ptit Suisse ?
        valp, vectp = np.linalg.eig(self.mat)

        a = math.sqrt(valp[0])
        b = math.sqrt(valp[1])

        self.a = a
        self.b = b

        theta = math.atan2(vectp[0, 0], vectp[1, 0])
        theta2 = math.atan2(vectp[0, 1], vectp[1, 1])  # ligne, colonne
        theta3 = math.atan2(vectp[0, 2], vectp[1, 2])  # ligne, colonne
        self.theta = (theta * 180 / math.pi)
        if self.theta < 0:
            self.theta += 180

        if self.pt_name == "2104444":
            # print(f"Qaa:\n {self.mat} ")
            # print(f"3d:")
            # print(f"The eigenvalues of A are:\n {valp} ")
            # print(f"The matrix of eigenvectors, V, is:\n {vectp} ")
            # print(f"Azimut, {theta * 200 / math.pi}")
            # print(f"Azimut2, {theta2 * 200 / math.pi}")
            # print(f"Azimut3, {theta3 * 200 / math.pi}")
            # print(f"2d:")
            mat = np.mat(np.eye(2))
            mat[0, 0] = self.mat[0, 0]
            mat[0, 1] = self.mat[0, 1]
            mat[1, 0] = self.mat[1, 0]
            mat[1, 1] = self.mat[1, 1]
            valp, vectp = np.linalg.eig(mat)
            # print(f"The eigenvalues of A are:\n {valp} ")
            # print(f"The matrix of eigenvectors, V, is:\n {vectp} ")
            theta = math.atan2(vectp[0, 0], vectp[1, 0])
            theta2 = math.atan2(vectp[0, 1], vectp[1, 1])  # ligne, colonne
            # print(f"Azimut, {theta * 200 / math.pi}")
            # print(f"Azimut2, {theta2 * 200 / math.pi}")

    def get_attributes(self):
        """

        :return: ['pt_name', 'diag_mat', 'mat', 'sigma_x', 'sigma_y', 'sigma_z', 'a', 'b', 'theta', 'factor']
        """
        return list(self.__dict__.keys())

    def get_qgis_fields(self):
        """

        :return: [<QgsField: a ()>, <QgsField: b ()>, <QgsField: diag_mat ()>, <QgsField: factor ()>, <QgsField: mat ()>, <QgsField: pt_name ()>, <QgsField: theta ()>]
        """
        lst_qgis_fields = []
        for att in dir(self):
            if not att.startswith('__') and not callable(getattr(self, att)):
                pytype = type(getattr(self, att))
                lst_qgis_fields.append(QgsField(att, type_py2gpkg(pytype)))
        return lst_qgis_fields
