from __future__ import absolute_import
from PyQt5.QtCore import QVariant
from qgis.core import QgsField, QgsFields, QgsFeature, QgsVectorLayerUtils
from .functions import type_py2gpkg

from qgis.core import QgsVectorLayer


class Comp3dComputation:
    """
        Class object Computation
        """
    fields = [
        QgsField("name", QVariant.String),
        QgsField("computation_start", QVariant.String),
        QgsField("description", QVariant.String),
        QgsField("compute_type", QVariant.Int),
        QgsField("is_georef", QVariant.Int),
        QgsField("input_proj_EPSG", QVariant.Int),
        QgsField("input_proj_name", QVariant.String),
        QgsField("earth_model_radius", QVariant.Double),
        QgsField("use_vertical_deviation", QVariant.Int),
        QgsField("invert_matrix", QVariant.Int),
        QgsField("use_ellips_height", QVariant.Int),
        QgsField("html_path", QVariant.String),
    ]

    def __init__(self, timestamp_id, name, computation_start, description, compute_type, is_georef, input_proj_EPSG,
                 input_proj_def, input_proj_name, local_center,
                 earth_model_radius, use_vertical_deviation, invert_matrix, use_ellips_height, html_path):
        self.timestamp_id = str(timestamp_id)
        self.name = name
        self.computation_start = computation_start
        self.description = description
        self.compute_type = compute_type
        self.is_georef = is_georef
        self.input_proj_EPSG = input_proj_EPSG
        self.input_proj_def = input_proj_def
        self.input_proj_name = input_proj_name
        self.local_center = local_center
        self.earth_model_radius = earth_model_radius
        self.use_vertical_deviation = use_vertical_deviation
        self.invert_matrix = invert_matrix
        self.use_ellips_height = use_ellips_height
        self.lst_observations = []
        self.lst_points = []
        self.lst_ellipses = []
        self.lst_indeterminations = []
        self.html_path = html_path


    def values(self):
        values = []
        for a in self.__dict__.values():
            values.append(a)
        return values

    def get_attributes(self):
        lst_attr = []
        for att in dir(self):
            if not att.startswith('__') and not callable(getattr(self, att)):
                if not att.startswith('lst_'):
                    lst_attr.append(att)
        return lst_attr

    def get_qgis_fields(self):
        lst_qgis_fields = []
        for att in dir(self):
            if not att.startswith('__') and not callable(getattr(self, att)):
                if not att.startswith('lst_'):
                    pytype = type(getattr(self, att))
                    lst_qgis_fields.append(QgsField(att, type_py2gpkg(pytype)))
        return lst_qgis_fields

    def get_pt_from_name(self, name):
        for pt in self.lst_points:
            if pt.name == name:
                return pt
        raise NotImplementedError(
            f"Point {name} not found")


    def get_layer_dfn(self):
        layer = QgsVectorLayer('None', 'computations', 'memory')
        layer_provider = layer.dataProvider()
        layer_provider.addAttributes(self.fields)
        layer.updateFields()
        return layer

    def get_as_feature(self, lyr_dfn):

        feat = QgsVectorLayerUtils.createFeature(lyr_dfn)
        feat.setAttributes([self.timestamp_id, self.name])

        return feat

    def get_as_list_fields_values(self):
        """fields = [
            QgsField("timestamp_id", QVariant.Int),
            QgsField("name", QVariant.String),
            QgsField("computation_start", QVariant.String),
            QgsField("description", QVariant.String),
            QgsField("compute_type", QVariant.Int),
            QgsField("is_georef", QVariant.Int),
            QgsField("input_proj_EPSG", QVariant.Int),
            QgsField("input_proj_name", QVariant.String),
            QgsField("earth_model_radius", QVariant.Double),
            QgsField("use_vertical_deviation", QVariant.Int),
            QgsField("invert_matrix", QVariant.Int),
            QgsField("use_ellips_height", QVariant.Int),
            QgsField("html_path", QVariant.String),
        ]"""

        return [self.timestamp_id, self.name, self.computation_start, self.description, self.compute_type,
                self.is_georef, self.input_proj_EPSG, self.input_proj_name, self.earth_model_radius,
                self.use_vertical_deviation, self.invert_matrix, self.use_ellips_height, self.html_path]

